// napple1 ncurses Apple 1 emulator
// Copyright (C) 2008 Nobu Hatano
//
// Pom1 Apple 1 Emulator
// Copyright (C) 2000 Verhille Arnaud
// Copyright (C) 2006 John D. Corrado
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "pia6820.h"
#include "memory.h"
#include "screen.h"
#include "configuration.h"

#define MEMMAX 0xFFFF

static unsigned char mem[65536];

void loadBasic(void)
{
	FILE *fd = fopen("rom/basic.rom", "rb");
	if (fd) {
		fread(&mem[0xE000], 1, 4096, fd);
		fclose(fd);
	}
}

int loadMonitor(void)
{
	FILE *fd = fopen("rom/monitor.rom", "rb");

	if (fd) {
		fread(&mem[0xFF00], 1, 256, fd);
		fclose(fd);
	}
	else{
		return 0;
	}

	return 1;
}

int loadReplica1(void)
{
	FILE *fd = fopen("rom/6502.rom.bin", "rb");

	if (fd) {
		fread(&mem[0xE000], 1, 8192, fd);
		fclose(fd);
	}
	else {
		return 0;
	}

	return 1;
}

void resetMemory(void)
{
	if (getReplica1())
		memset(mem, 0, 0xE000); /* replica1 rom staring at 0xE. */
	else
		memset(mem, 0, 0x10000 - 256); /* rom is within tail 256b */
}

unsigned char memRead(unsigned short address)
{
	if (address == 0xD013)
		return readDspCr();
	if (address == 0xD012)
		return readDsp();
	if (address == 0xD011)
		return readKbdCr();
	if (address == 0xD010)
		return readKbd();

	return mem[address];
}

void memWrite(unsigned short address, unsigned char value)
{
	if (address < 0x1000)	
		mem[address] = value;
	else if (address < 0x8000 && getReplica1())
		mem[address] = value;
	else if (address == 0xD013)
		writeDspCr(value);
	else if (address == 0xD012)
		writeDsp(value);
	else if (address == 0xD011)
		writeKbdCr(value);
	else if (address == 0xD010)
		writeKbd(value);
	else
		;

	return;
}

void core(void)
{
	FILE *fd = fopen("napple1.core", "w");
	int i;

	for (i = 0; i <= MEMMAX; i++)
		fputc(mem[i], fd);
	fclose(fd);
}

int loadCore(void)
{
	FILE *fd = fopen("napple1.core", "rb");

	if (fd) {
		fread(&mem[0], 1, MEMMAX+1, fd);
		fclose(fd);
	} else{
		return 0;
	}

	return 1;
}

unsigned char *dumpMemory(unsigned short start, unsigned short end)
{
	unsigned char *fbrut = (unsigned char *)malloc(sizeof(unsigned char) * (end - start + 1));

 	memcpy(fbrut, &mem[start], end - start + 1);

	return fbrut;
}

